



/*********************************************************************************************************************
 *                                                                                                                   *
 *                                  Example_1. ET-REMOTE MP3 Trig-Mode By Command                                    *
 *                                                                                                                   *
 *********************************************************************************************************************
 *                                                                                                                   *
 * Target MCU        : PIC18F8722 (ET-BASE PIC8722 (ICD2))                                                           *
 *                   : X-TAL : 10 MHz                                                                                *
 *                   : CPU Clock = 40 MHz (x4)                                                                       *                                                                  
 * Editor-Compiler   : CCS Version 4.120                                                                             *
 *                                                                                                                   *
 *                                                                                                                   *
 * Port Interface    :  # MCU-18F8722 #            # ET-MINI 3TO5TTL #                     # ET-REMOTE MP3 #         *
 *                      --------------             -------------------                     -----------------         * 
 *                                                                                                                   *
 *       I/O TRIG    :  PORT RD[0..7]   Connect  IN0-IN7(#1)<--> OUT0-OUT7(#1)   Connect    Trig CH1-CH8             * 
 *                      PORT RE[0..7]   Connect  IN0-IN7(#2)<--> OUT0-OUT7(#2)   Connect    Trig CH9-CH16            *
 *                      5V              Connect  +VIN(#1,#2)<--> +VOUT(#1,#2)    Connect    +3.3V                    *
 *                      G1              Connect  G1  (#1,#2)<--> +G2  (#1,#2)    Connect    G2                       *
 *                                                                                                                   *
 *       UART1       :  PORT RC6 = TX1                                                                               *
 *                      PORT RC7 = RX1                                                                               *
 *                      Baud Rate 9600                                                                               *
 *                                                                                                                   *
 *                                                                                                 -DIP SW.MODE      *
 *      RS232 CMM          5V                                                                       S1=OFF,S2=OFF    *
 *      Tx  Rx1           --+--                                            +------------------+    -DIF SW.CONFIG    *
 *       ^   ^              |                                              |                  |     S1=OFF,S2=ON     *
 *       |   |              +----------+                                   |          --------+-----------           *
 *       |   |              |          |      -----------------------      |         |     +VOUT3V3       |          *
 *       |   |        ------+-----     +-----|+VIN              +VOUT|-----+    Trig |                    |          *
 *       |   |       |        RD0 |----|-----|IN0                OUT0|-----|---------|CH1                 |          *
 *       |   +-------|RC7      .  |    |     | .                  .  |     |         | .                  |          *
 *       |           |         .  |    |     | .   ET-MINI3TO5#1  .  |     |         | .                  |          *
 *       |           |         .  |    |     | .                  .  |     |         | .                  |          *
 *       |           |        RD7 |----|-----|IN7                OUT7|-----|---------|CH8                 |          *
 *       |           |            |    |  +--|G1                  G2 |--+  |         |                    |          *
 *       |           |            |    |  |  +-----------------------+  |  |         |   ET-REMOTE MP3V2  |          *
 *       |           |            |    +--|--|+VIN              +VOUT|--|--+    Trig |                    |          *
 *       |           |        RE0 |-------|--|IN0                OUT0|--|------------|CH9                 |          *
 *       |           |         .  |       |  | .                  .  |  |            | .                  |          *
 *       |           |         .  |       |  | .   ET-MINI3TO5#2  .  |  |            | .                  |          *
 *       +-----------|RC6      .  |       |  | .                  .  |  |            | .                  |          *
 *                   |        RE7 |-------|--|IN7                OUT7|--|------------|CH16   [Supply]     |          *
 *                    -----+------        +--|G1                   G2|--+            |       G2   5V      |          *
 *                         | PIC18F8722   |   -----------------------   |             -------+-----+------           *
 *                       --+--          --+--                           |                    |     |                 *
 *                        ---            ---                            +--------------------+     |                 *
 *                         -              -                                                  |     +-->5V            *
 *                                                                                         --+--                     *
 *                                                                                         \   /                     *
 *                                                                                          \ /                      *
 *                                                                                                                   *
 *                                                                                                                   *
 *   ASCII Command For Test :  +----------+-------------+---------------+                                            *
 *                             |Start Byte| Number Song |      End      |                                            *
 *                             +----------+-------------+---------------+                                            *
 *                             |  1Byte   |   2Byte     |    1 Byte     |                                            *
 *                             +----------+-------------+---------------+                                            *
 *                             |    *     |    01-16    |  0x0D (Enter) |                                            *
 *                             +----------+-------------+---------------+                                            *
 *                                                                                                                   *
 * Last Update       : 1/June/2012                                                                                   *
 * Create By         : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                                          *
 *                                                                                                                   *
 *********************************************************************************************************************/


#include <18F8722.h>
#include <stdio.h>

#define TX1   PIN_C6
#define RX1   PIN_C7

#fuses H4,NOLVP,NOWDT,NOPROTECT,NOSTVREN         //Setup MCU
#use delay (clock = 40000000)                    //delay Clock = (ms)
#use rs232(baud = 9600, xmit = TX1, rcv = RX1)   //Set Rs232

#use fast_io(ALL)  //Stop Set direction Auto for All Port  by Compiler  


int8 enter,cmm_cnt=0,cmm_buf[3] ;

/*****************************************
 **       Function Initial UART1        **
 *****************************************/

void UART1_Init(void)
 {
   set_tris_C(0x80)             ;        //Set RX(RC7) = In,TX(RC6)=Out,RC5..RC0 = Out
   enable_interrupts(GLOBAL)    ;
   enable_interrupts(INT_RDA)   ;

 }


/*****************************************
 **        Function Initial Port        **
 *****************************************/

 void Init_Port(void)
  {   
    set_tris_D(0x00)             ;        //Set RD(0..7) = Output for Trig CH1-8    
    set_tris_E(0x00)             ;        //Set RE(0..7) = Output for Trig CH9-16  
    

  //--- Set default output Port For Trig = 1  ----
                
   OUTPUT_D(0xFF)                  ;       //CH1-CH8  
   OUTPUT_E(0xFF)                  ;       //CH9-CH16
   
 }


/****************************************************
 **                                                **
 **     Function Interrup Service-Uart1 RX1        **
 **                                                **
 ****************************************************/ 
 
#INT_RDA
void IntRDA_isr(void)
 {  
    int8 rxd             ;
    
     rxd   = getc()      ;  //Read data 
   
     if(rxd != 0x0D)           
       {
         //--------- Keep Command 3 byte : *,cmm,cmm --------------   
   
         if(cmm_cnt < 3)
           {   
             cmm_buf[cmm_cnt] = rxd    ;  // keep data
             cmm_cnt++                 ;
           }
       }
   
        //------ Clear Valiable for Recive New Command -------------

     if(rxd == 0x0D)               
       {
          enter = 0x0D                ;  
          cmm_cnt = 0                 ;  //Clear Counter Command   
       }
 }



/****************************************************
 **                                                **
 **              Function Read Command             **
 **                                                **
 ****************************************************/ 


void chk_cmm(void)
 {
     int8 cm1,cm2 ; 

     if(enter == 0x0D)                          // Check Enter
      {  
       enter  = 0x00  ;                         // Clear valiable 'enter'
         
         if(cmm_buf[0]== '*')                   // Check Start Byte
          {       
            cm1 = (cmm_buf[1]-0x30)*10    ;    //Convert CMM Ascii to  decimal colum 10
            cm2 = (cmm_buf[2]-0x30)+cm1   ;    //Convert CMM Ascii to  decimal colum 1
                         
                           
              //------------------ Sent Signal Trig Follow Command -----------------------

            switch(cm2)
             {
              case 1 :     //--------------- TRIG-CH1(RD0)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     output_low(PIN_D0)    ;    //RD0=0 : Trig-CH1   
                   
                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     output_high(PIN_D0)   ;    //RD0=1  

                     printf("#OK\n\r")      ;    //Sent Echo Command 
              
                     break ;

             case 2 :     //--------------- TRIG-CH2(RD1)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     output_low(PIN_D1)    ;    //RD1=0 : Trig-CH2   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     output_high(PIN_D1)   ;    //RD1=1  

                     printf("#OK\n\r")     ;    //Sent Echo Command 
                   
                     break ;

             case 3 : //--------------- TRIG-CH3(RD2)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     output_low(PIN_D2)    ;    //RD2=0 : Trig-CH3   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     output_high(PIN_D2)   ;    //RD2=1  

                     printf("#OK\n\r")      ;    //Sent Echo Command 
                   
                     break ;

              case 4 :     //--------------- TRIG-CH4(RD3)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     output_low(PIN_D3)    ;    //RD3=0 : Trig-CH4   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     output_high(PIN_D3)   ;    //RD3=1  
 
                     printf("#OK\n\r")     ;    //Sent Echo Command 
                   
                     break ;
           
              case 5 :     //--------------- TRIG-CH5(RD4)-------------

                     cmm_buf[0] = 0xFF      ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF      ;
                     cmm_buf[2] = 0xFF      ;              
                      
                     output_low(PIN_D4)     ;    //RD4=0 : Trig-CH5   

                     delay_ms(20)           ;    //Delay 20 ms for Trig 0

                     output_high(PIN_D4)    ;    //RD4=1  

                     printf("#OK\n\r")      ;    //Sent Echo Command 
            
                     break ;
          
              case 6 :     //--------------- TRIG-CH6(RD5)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     output_low(PIN_D5)    ;    //RD5=0 : Trig-CH6   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     output_high(PIN_D5)    ;    //RD5=1  

                     printf("#OK\n\r")      ;    //Sent Echo Command 
              
                     break ;


            
              case 7 :     //--------------- TRIG-CH7(RD6)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     output_low(PIN_D6)    ;    //RD6=0 : Trig-CH7   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0
 
                     output_high(PIN_D6)   ;    //RD6=1  

                     printf("#OK\n\r")     ;    //Sent Echo Command 
              
                     break ;

            
                 case 8 :     //--------------- TRIG-CH8(RD7)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     output_low(PIN_D7)    ;    //RD7=0 : Trig-CH8   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     output_high(PIN_D7)   ;    //RD7=1  
 
                     printf("#OK\n\r")     ;    //Sent Echo Command 
            
                     break ;

    
                 case 9 :     //--------------- TRIG-CH9(RE0)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     output_low(PIN_E0)    ;    //RE0=0 : Trig-CH9   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     output_high(PIN_E0)   ;    //RE0=1  

                     printf("#OK\n\r")     ;    //Sent Echo Command 
                     
                     break ;


             case 10 :     //--------------- TRIG-CH10(RE1)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     output_low(PIN_E1)    ;    //RE1=0 : Trig-CH10   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     output_high(PIN_E1)   ;    //RE1=1  

                     printf("#OK\n\r")     ;    //Sent Echo Command 
              
                     break ;


             case 11 :     //--------------- TRIG-CH11(RE2)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     output_low(PIN_E2)    ;    //RE2=0 : Trig-CH11   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     output_high(PIN_E2)   ;    //RE2=1  

                     printf("#OK\n\r")     ;    //Sent Echo Command 
             
                     break ;


            case 12 :     //--------------- TRIG-CH12(RE3)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     output_low(PIN_E3)    ;    //RE3=0 : Trig-CH12   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     output_high(PIN_E3)   ;    //RE3=1  

                     printf("#OK\n\r")     ;    //Sent Echo Command 
            
                     break ;


            case 13 :     //--------------- TRIG-CH13(RE4)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     output_low(PIN_E4)    ;    //RE4=0 : Trig-CH13   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     output_high(PIN_E4)   ;    //RE4=1  

                     printf("#OK\n\r")     ;    //Sent Echo Command 
           
                     break ;



            case 14 :     //--------------- TRIG-CH14(RE5)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     output_low(PIN_E5)    ;    //RE5=0 : Trig-CH14   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     output_high(PIN_E5)   ;    //RE5=1  

                     printf("#OK\n\r")     ;    //Sent Echo Command 
             
                     break ;


             case 15 :     //--------------- TRIG-CH15(RE6)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     output_low(PIN_E6)    ;    //RE6=0 : Trig-CH15   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     output_high(PIN_E6)   ;    //RE6=1  

                     printf("#OK\n\r")     ;    //Sent Echo Command 
            
                     break ;


             case 16 :     //--------------- TRIG-CH16(RE7)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     output_low(PIN_E7)    ;    //RE7=0 : Trig-CH16   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     output_high(PIN_E7)   ;    //RE7=1  

                     printf("#OK\n\r")     ;    //Sent Echo Command 
                  
                     break ;

             
            }   // if switch
          } // if cmm
       }  // if enter


}



/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
void main(void) 
 {

   Init_Port()       ;

   UART1_Init()      ;
   delay_ms(2000)    ;  //delay for Sync Borad MP3 Ready 

   printf("########### ET-REMOTE MP3 V2. ==> PLAY TRIG MODE #########\n\r") ;

   while(true)
   {
     chk_cmm() ;
   }   
 
}
 
  
  
  
  
  
  
  
  
  
  
  
